<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class perkara_m extends CI_Model{
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			$result = $this->db->get('alurperkaraweb');
			if($result->num_rows>0){
				return $result->row()->nama;
			}else{
				return 'Alur Perkara Tidak Ditemukan';
			}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	
	function isNomorPerkara($txt){
		$re1='(\\d+)';	# Integer Number 1
		$re2='(\\/)';	# Any Single Character 1
		$re3='.*?';	# Non-greedy match on filler
		$re4='(\\/)';	# Any Single Character 2
		$re5='((?:(?:[1]{1}\\d{1}\\d{1}\\d{1})|(?:[2]{1}\\d{3})))(?![\\d])';	# Year 1
		$re6='(\\/)';	# Any Single Character 3
		$re7='(PN)';	# Variable Name 1
		if ($c=preg_match_all ("/".$re1.$re2.$re3.$re4.$re5.$re6.$re7."/is", $txt, $matches)){
		      $int1=$matches[1][0];
		      $c1=$matches[2][0];
		      $c2=$matches[3][0];
		      $year1=$matches[4][0];
		      $c3=$matches[5][0];
		      $var1=$matches[6][0];
		      return 1;
		}else{
			return 0;
		}
	}

	function parseOrderby($col){
		if($col==1){
			return "noPerkara"; 
		}else if($col==2){
			return "tglPendaftaran"; 
		}else if($col==3){
			return "jenisPerkara"; 
		}else if($col==4){
			return "pihakPertama,pihakKedua"; 
		}else if($col==5){
			return "statusAkhir"; 
		}else if($col==6){
			return "statusAkhir"; 
		}else if($col==7){
			return "durasi"; 
		}else{
			return "tglPendaftaran";
		}
	}

	function getPerkaraList($idalurperkara='',$col=2,$type='DESC',$begin=0,$key=''){
		$orderby = $this->parseOrderby($col);
		$where = '';
		

		if($idalurperkara>0){
			$where = "AND klasifikasiPerkara IN (".$idalurperkara.")";
		}else{
			$where = "";
		}

		if(!empty($key)){
			if($this->isNomorPerkara($key)){
				$where_like = ' WHERE noPerkara = "'.$key.'" ';
			}elseif(is_numeric($key)){
				$where_like = ' WHERE noPerkara LIKE "'.$key.'%" ';
			}else{
				$where_like = ' WHERE (noPerkara LIKE "%'.$key.'%" OR tglPendaftaran LIKE "%'.$key.'%" OR jenisPerkara LIKE "%'.$key.'%" OR pihakPertama LIKE "%'.$key.'%" OR pihakKedua LIKE "%'.$key.'%" OR statusAkhir LIKE "%'.$key.'%") ';
			}
		}else{
			$where_like =" ";
			if($idalurperkara>0){
				$where = " WHERE klasifikasiPerkara IN (".$idalurperkara.")";
			}
		}
		try {
			$query = $this->db->query("SELECT SQL_CALC_FOUND_ROWS IDPerkara, klasifikasiPerkara,jenisPerkara,statusAkhir,noPerkara
				,tglPendaftaran,pihakPertama, pihakKedua,
				IF(IDProses<220,DATEDIFF(CURDATE(),tglPendaftaran), DATEDIFF(tglMinutasi,tglPendaftaran) ) AS durasi
				FROM dataumumweb  ".$where_like." ".$where." ORDER BY ".$orderby." ".$type." ,tglPendaftaran DESC LIMIT ".$begin.",20");
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getPerkaraListSearchDetil($where,$col=2,$type='DESC',$begin=0){
		$orderby = $this->parseOrderby($col);
		try {
			$query = $this->db->query("SELECT SQL_CALC_FOUND_ROWS dataumumweb.IDPerkara, klasifikasiPerkara,jenisPerkara,statusAkhir,noPerkara
				,tglPendaftaran,pihakPertama, pihakKedua,
				IF(IDProses<220,DATEDIFF(CURDATE(),tglPendaftaran), DATEDIFF(tglMinutasi,tglPendaftaran) ) AS durasi
				FROM dataumumweb ".$where." GROUP BY dataumumweb.IDPerkara ORDER BY ".$orderby." ".$type." ,tglPendaftaran DESC LIMIT ".$begin.",20");
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function fecth_data_num(){
		$query = $this->db->query("SELECT FOUND_ROWS() as cnt;");
		if($query->num_rows>0){
			foreach ($query->result() as $row) {
				return $row->cnt;
			}
    		return $query->num_rows;
    	}else{
    		return 0;
    	}
	}
}